// Copyright (C) 2012 EPITA Research and Development Laboratory (LRDE)

#ifndef MLN_DEMO_SRC_IMAGE_VIEWER_HH
# define MLN_DEMO_SRC_IMAGE_VIEWER_HH

# include <QApplication>
# include <QtCore>
# include <QtGui>

# include <ui_image_viewer.h>

# include <mln/core/image/image2d.hh>
# include <mln/convert/to_qimage.hh>
# include <interactive_scene.hh>


namespace mln
{

  namespace demo
  {

    typedef value::qt::rgb32 dsp_data_t;

    class image_viewer
      : public QWidget, private Ui::ImageViewer
    {
      Q_OBJECT;

    public:
      image_viewer(QWidget *parent = 0);
      ~image_viewer();

      unsigned current_slice() const;

      internal::interactiveScene * scene();
      const internal::interactiveScene * scene() const;

      void clear();
      void expand_to_content();

    private: // members
      void setup_scene();

      void draw_image(const QImage& ima);

      void resize_image(const QRectF& rect);

      void keyPressEvent(QKeyEvent *event);
      void resizeEvent(QResizeEvent * event);
//       void mouseMoveEvent(QMouseEvent *e);
//       void mousePressEvent(QMouseEvent *e);
//       void mouseReleasedEvent(QMouseEvent *e);

    public slots:
      void visible_slider(bool b);

      void move_vertical_sliders(int value);
      void move_horizontal_sliders(int value);

      void on_slider_valueChanged(int sli);

      void on_zoomIn_clicked();
      void on_zoomOut_clicked();
      void on_zoomFixed_clicked();
      void on_zoomOriginal_clicked();


    public slots:
      void set_image_layer_count(unsigned nslis);
      void update_image(const mln::image2d<dsp_data_t>& ima);
      void update_image(const QImage& ima);


    signals:
      void slider_valueChanged(int sli);

    private: // attributes
      QGraphicsItem *item_;
      bool mouse_moving_;
      QPoint p_start_;
    };


  } // end of namespace mln::demo

} // end of namespace mln


#endif // ! MLN_DEMO_SRC_IMAGE_VIEWER_HH
