#!/bin/sh

if [ $# -ne 2 ]; then
    echo "Usage: $0 <path_to_impl_dirs> <path_to_ocr_gt>"
    exit 1;
fi

IMPL="kim niblack otsu sauvola sauvola_msk sauvola_mskx wolf"

echo "\033[1;32mChecking number of files!\033[m"

error=0
file_count=`find $1/kim/medium $1/kim/small $1/kim/large -type f | wc -l`
for impl in $IMPL "bboxes"; do
    impl_file_count=`find $1/$impl/small $1/$impl/medium $1/$impl/large -type f | wc -l`
    if [ $impl_file_count -ne $file_count ]; then
       echo "ERROR in $impl: the number of files is different from other directories ($impl_file_count vs $file_count)!";
       error=1
    fi
done

if [ `find $2/ocr_gt/small $2/ocr_gt/medium $2/ocr_gt/large -type f | wc -l` -ne `echo "$file_count/2" | bc` ]; then
   echo "ERROR in ocr_gt: the number of files should be half of the others!"
   error=1
fi

echo "\033[1;32mChecking OCR GT emptyness!\033[m"
empty=`find $2/ocr_gt/small $2/ocr_gt/medium $2/ocr_gt/large -size 1c`
if ! [ -z "$empty" ]; then
    echo "ERROR in ocr_gt: Some OCR groundtruth files are empty: "
    echo "$empty"
    error=1
fi

if [ $error -eq 0 ]; then
    echo "\033[1;32mEverything is fine!\033[m"
else
    echo "\033[1;31mFix results before benchmarking!\033[m"
fi