// Copyright (C) 2012 EPITA Research and Development Laboratory (LRDE)
//
// This code is published as free software: you can redistribute it
// and/or modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation, version 2 of the
// License.
//
// This code is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License.
// If not, see <http://www.gnu.org/licenses/>.

#include <iostream>
#include <mln/core/image/image2d.hh>
#include <mln/io/magick/load.hh>
#include <mln/data/convert.hh>


using namespace mln;

void error(const char *txt)
{
  std::cout << txt << std::endl;
  exit(1);
}

void compare(const image2d<bool>& img, const image2d<bool>& gt)
{
  double Ctp=0, Cfp=0, Cfn=0;

  mln_pixter(const image2d<bool>) pi(img);
  mln_pixter(const image2d<bool>) pgt(gt);
  for_all_2(pi,pgt)
    if (pi.val() && pgt.val())
      Ctp++;
    else if (pi.val() && !pgt.val())
      Cfp++;
    else if (! pi.val() && pgt.val())
      Cfn++;

  double RC=Ctp/(Cfn+Ctp);
  double PR=Ctp/(Cfp+Ctp);
  double FM=(2*RC*PR/(RC+PR))*100;

  std::cout << "Ctp " << Ctp
	    << " Cfp " << Cfp
	    << " Cfn " << Cfn
	    << " Precision " << PR
	    << " Recall " << RC
	    << " F-Measure " << FM << std::endl;
}


int main(int argc, char *argv[])
{
  if (argc!=3)
    error("Usage : ./eval_gt img_result.* img_gt.*");

  Magick::InitializeMagick(0);

  image2d<value::rgb8> image_, gt_;
  io::magick::load(image_, argv[1]);
  io::magick::load(gt_, argv[2]);
  image2d<bool> image = data::convert(bool(), image_);
  image2d<bool> gt = data::convert(bool(), gt_);

  if(image.domain() != gt.domain())
    error("ERROR: Input images do not have the same dimension!");

  compare(image, gt);
}
