/*
 * Decompiled with CFR 0.152.
 */
package edu.osu.ling.pep;

import edu.osu.ling.pep.Category;
import java.util.Arrays;

public class Rule {
    Category left;
    Category[] right;

    public Rule(Category left, Category ... right) {
        if (left == null) {
            throw new IllegalArgumentException("empty left category");
        }
        if (left.terminal) {
            throw new IllegalArgumentException("left category is terminal");
        }
        if (right == null || right.length == 0) {
            throw new IllegalArgumentException("no right categories");
        }
        for (Category r : right) {
            if (r != null) continue;
            throw new IllegalArgumentException("right contains null category: " + Arrays.toString(right));
        }
        this.left = left;
        this.right = right;
    }

    public Category getLeft() {
        return this.left;
    }

    public Category[] getRight() {
        return this.right;
    }

    public boolean isPreterminal() {
        for (Category r : this.right) {
            if (!r.terminal) continue;
            return true;
        }
        return false;
    }

    public boolean isSingletonPreterminal() {
        return this.isPreterminal() && this.right.length == 1;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Rule) {
            Rule or = (Rule)obj;
            return this.left.equals(or.left) && Arrays.equals(this.right, or.right);
        }
        return false;
    }

    public int hashCode() {
        return 31 * this.left.hashCode() * Arrays.hashCode(this.right);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.left.toString());
        sb.append(" ->");
        for (int i = 0; i < this.right.length; ++i) {
            sb.append(' ');
            sb.append(this.right[i].toString());
        }
        return sb.toString();
    }
}

