/*
 * Decompiled with CFR 0.152.
 */
package edu.osu.ling.pep;

import edu.osu.ling.pep.Category;
import edu.osu.ling.pep.DottedRule;
import edu.osu.ling.pep.Edge;
import java.util.Arrays;
import java.util.Iterator;

public class ParseTree {
    Category node;
    ParseTree parent;
    ParseTree[] children = null;

    public ParseTree(Category node, ParseTree parent) {
        this(node, parent, null);
    }

    public ParseTree(Category node, ParseTree parent, ParseTree[] children) {
        this.node = node;
        this.parent = parent;
        this.children = children;
    }

    public static ParseTree newParseTree(Edge edge) {
        return ParseTree.newParseTree(edge, null);
    }

    public static ParseTree newParseTree(Edge edge, ParseTree parent) {
        ParseTree parentTree;
        Edge e;
        if (edge.dottedRule.left.equals(Category.START)) {
            e = edge.bases.iterator().next();
            parentTree = null;
        } else {
            e = edge;
            parentTree = parent != null && parent.node.equals(Category.START) ? null : parent;
        }
        DottedRule dr = e.dottedRule;
        ParseTree newTree = null;
        if (e.isPassive()) {
            int basisCount = e.bases.size();
            newTree = new ParseTree(dr.left, parentTree, basisCount == 0 ? null : new ParseTree[basisCount]);
            if (basisCount > 0) {
                int i = 0;
                Iterator<Edge> itr = e.bases.iterator();
                while (itr.hasNext()) {
                    newTree.children[i++] = ParseTree.newParseTree(itr.next(), newTree);
                }
            }
        } else {
            newTree = new ParseTree(dr.activeCategory, parentTree, null);
        }
        return newTree;
    }

    public Category getNode() {
        return this.node;
    }

    public ParseTree getParent() {
        return this.parent;
    }

    public ParseTree[] getChildren() {
        return this.children;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ParseTree) {
            ParseTree op = (ParseTree)obj;
            return this.node.equals(op.node) && (this.parent == null && op.parent == null || this.parent.node.equals(op.parent.node)) && (this.children == null && op.children == null || Arrays.equals(this.children, op.children));
        }
        return false;
    }

    public int hashCode() {
        int hash = 31 * this.node.hashCode();
        if (this.parent != null) {
            hash *= 17 * this.parent.node.hashCode();
        }
        if (this.children != null) {
            hash *= Arrays.hashCode(this.children);
        }
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        sb.append(this.node.toString());
        if (this.children != null) {
            for (ParseTree child : this.children) {
                sb.append(child.toString());
            }
        }
        sb.append(']');
        return sb.toString();
    }
}

