/*
 * Decompiled with CFR 0.152.
 */
package edu.osu.ling.pep;

import edu.osu.ling.pep.Category;
import edu.osu.ling.pep.EarleyParser;
import edu.osu.ling.pep.EdgeEvent;
import edu.osu.ling.pep.Grammar;
import edu.osu.ling.pep.Parse;
import edu.osu.ling.pep.ParseErrorEvent;
import edu.osu.ling.pep.ParseEvent;
import edu.osu.ling.pep.ParseTree;
import edu.osu.ling.pep.ParserListener;
import edu.osu.ling.pep.ParserOption;
import edu.osu.ling.pep.ParserOptionEvent;
import edu.osu.ling.pep.PepException;
import edu.osu.ling.pep.Rule;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.Set;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pep
implements ParserListener {
    static final float VERSION = 0.4f;
    static final int V_ALL = 0;
    static final int V_RECOGNITION = 0;
    static final int V_WARN = 1;
    static final int V_PARSE = 1;
    static final int V_CHART = 2;
    static final int V_GRAMMAR = 3;
    static final int V_STATS = 3;
    static final int V_DEBUG = 3;
    static int verbosity = 0;
    EarleyParser earleyParser;
    Map<ParserOption, Boolean> parserOptions;
    long lastParseStart;

    Pep(Map<ParserOption, Boolean> parserOptions) {
        this.parserOptions = parserOptions;
    }

    Parse parse(Grammar grammar, List<String> tokens, Category seed) throws PepException {
        if (this.earleyParser == null) {
            this.earleyParser = new EarleyParser(grammar, this);
            if (this.parserOptions != null) {
                for (Map.Entry<ParserOption, Boolean> entry : this.parserOptions.entrySet()) {
                    this.earleyParser.setOption(entry.getKey(), entry.getValue());
                }
            }
        }
        if (verbosity >= 3) {
            Pep.printMessage("Parsing " + tokens + " for category " + seed, 3);
        }
        return this.earleyParser.parse(tokens, seed);
    }

    @Override
    public void optionSet(ParserOptionEvent optionEvent) {
        if (verbosity >= 3) {
            Pep.printMessage("Option set: " + optionEvent.option.name() + "=" + optionEvent.value, 3);
        }
    }

    @Override
    public void parserSeeded(EdgeEvent edgeEvent) {
        Pep.printParser(edgeEvent.index, "seed     ", edgeEvent.edge);
    }

    @Override
    public void edgeCompleted(EdgeEvent edgeEvent) {
        Pep.printParser(edgeEvent.index, "complete", edgeEvent.edge);
    }

    @Override
    public void edgePredicted(EdgeEvent edgeEvent) {
        Pep.printParser(edgeEvent.index, "predict ", edgeEvent.edge);
    }

    @Override
    public void edgeScanned(EdgeEvent edgeEvent) {
        Pep.printParser(edgeEvent.index, "scan    ", edgeEvent.edge);
    }

    @Override
    public void parseComplete(ParseEvent parseEvent) {
        Set<ParseTree> parseTrees;
        long now = System.currentTimeMillis();
        Parse parse = parseEvent.parse;
        Pep.print("", 2);
        Pep.print(parse, 0);
        if (verbosity >= 1 && !(parseTrees = parse.getParseTrees()).isEmpty()) {
            int count = 1;
            for (ParseTree pt : parseTrees) {
                Pep.print(count++ + ". " + pt.toString(), 1);
            }
        }
        if (verbosity >= 3) {
            Pep.printMessage("", 3);
            Pep.printMessage("Parse complete: " + parse.chart.countEdges() + " edges added to chart in " + (now - this.lastParseStart) + " ms", 3);
        }
    }

    @Override
    public void parseMessage(ParseEvent parseEvent, String message) {
        Pep.printParser(parseEvent.index, "message ", message);
    }

    @Override
    public void parseError(ParseErrorEvent parseErrorEvent) throws PepException {
        Pep.printParser(parseErrorEvent.index, "error   ", parseErrorEvent.cause);
    }

    private static void print(Object line, int requiredVerbosity) {
        if (verbosity >= requiredVerbosity) {
            System.out.println(line);
        }
    }

    static void printMessage(String message, int requiredVerbosity) {
        if (verbosity >= requiredVerbosity) {
            System.err.println(message);
        }
    }

    private static void printError(String msg) {
        Pep.printMessage("Error: " + msg, 0);
    }

    private static void printError(Throwable error) {
        if (error instanceof SAXParseException) {
            SAXParseException spe = (SAXParseException)error;
            Pep.printError("line " + spe.getLineNumber() + ": " + spe.getMessage());
        } else {
            String msg = error.getMessage();
            Throwable cause = error.getCause();
            if (cause != null && !cause.equals(error)) {
                msg = msg + ": " + cause.getMessage();
            }
            Pep.printError(msg);
        }
    }

    static void printWarning(String msg) {
        Pep.printMessage("Warning: " + msg, 1);
    }

    private static void printHelp(Options options) {
        String name = Pep.class.getSimpleName();
        Pep.printMessage(name + " is an Earley Parser, version " + 0.4f, 0);
        Pep.printMessage("", 0);
        Pep.printMessage(name + " is free software, copyright (C) 2007 Scott Martin.", 0);
        Pep.printMessage("See the COPYING file for details.", 0);
        Pep.printMessage("", 0);
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("pep [options] [string] (use - for stdin)", options);
        Pep.printMessage("", 0);
        Pep.printMessage("where the default OPTION=value pairs are:", 0);
        for (ParserOption option : ParserOption.values()) {
            Pep.printMessage(' ' + option.toString(), 0);
        }
    }

    private static void printParser(int index, String label, Object obj) {
        if (verbosity >= 2) {
            StringBuilder sb = new StringBuilder(index + ": " + label + "\t");
            if (obj instanceof String) {
                sb.append('\'');
                sb.append(obj);
                sb.append('\'');
            } else if (obj instanceof Throwable) {
                sb.append(((Throwable)obj).getMessage());
            } else {
                sb.append(obj);
            }
            Pep.print(sb.toString(), 2);
        }
    }

    public static final void main(String[] args) {
        block15: {
            try {
                Options opts = new Options();
                OptionBuilder.withLongOpt("grammar");
                OptionBuilder.withDescription("the grammar to use");
                OptionBuilder.hasArg();
                OptionBuilder.isRequired();
                OptionBuilder.withArgName("grammar file");
                opts.addOption(OptionBuilder.create('g'));
                OptionBuilder.withLongOpt("seed");
                OptionBuilder.withDescription("the seed category to parse for");
                OptionBuilder.hasArg();
                OptionBuilder.isRequired();
                OptionBuilder.withArgName("seed category");
                opts.addOption(OptionBuilder.create('s'));
                OptionBuilder.withLongOpt("verbose");
                OptionBuilder.withDescription("0-3");
                OptionBuilder.hasOptionalArg();
                OptionBuilder.withArgName("verbosity level");
                opts.addOption(OptionBuilder.create('v'));
                OptionBuilder.withLongOpt("option");
                OptionBuilder.withDescription("sets parser options");
                OptionBuilder.withArgName("OPTION=value");
                OptionBuilder.hasArgs(2);
                OptionBuilder.withValueSeparator();
                OptionBuilder.withDescription("use value for given property");
                opts.addOption(OptionBuilder.create("o"));
                OptionBuilder.withLongOpt("help");
                OptionBuilder.withDescription("prints this message");
                opts.addOption(OptionBuilder.create('h'));
                GnuParser parser = new GnuParser();
                try {
                    CommandLine line = parser.parse(opts, args);
                    if (line.hasOption('h')) {
                        Pep.printHelp(opts);
                        break block15;
                    }
                    int v = Integer.parseInt(line.getOptionValue('v', Integer.toString(1)));
                    if (v < 0) {
                        throw new PepException("verbosity < 0: " + v);
                    }
                    verbosity = v;
                    EnumMap<ParserOption, Boolean> options = new EnumMap<ParserOption, Boolean>(ParserOption.class);
                    Properties props = line.getOptionProperties("o");
                    for (Object key : props.keySet()) {
                        try {
                            options.put(ParserOption.valueOf(key.toString()), Boolean.valueOf(props.get(key).toString()));
                        }
                        catch (IllegalArgumentException iae) {
                            Pep.printError("no option named " + key.toString());
                            Pep.printHelp(opts);
                            return;
                        }
                    }
                    Pep pep = new Pep(options);
                    Grammar grammar = new GrammarParser(Pep.findGrammar(line.getOptionValue('g'))).parse();
                    List ts = line.getArgList();
                    List<String> tokens = null;
                    if (ts.isEmpty() || ts.get(0).equals("-")) {
                        tokens = Pep.readTokens(new Scanner(System.in));
                    } else {
                        tokens = new ArrayList<String>(ts.size());
                        for (Object t : ts) {
                            tokens.add(t.toString());
                        }
                    }
                    pep.lastParseStart = System.currentTimeMillis();
                    try {
                        pep.parse(grammar, tokens, new Category(line.getOptionValue('s')));
                    }
                    catch (PepException ignore) {
                    }
                }
                catch (ParseException pe) {
                    Pep.printError("command-line syntax problem: " + pe.getMessage());
                    Pep.printHelp(opts);
                }
            }
            catch (PepException pe) {
                Throwable cause = pe.getCause();
                Pep.printError(cause == null ? pe : cause);
            }
            catch (RuntimeException re) {
                Pep.printError(re);
            }
        }
    }

    private static final File findGrammar(String grammarLoc) throws PepException {
        File g = new File(System.getProperty("user.dir"), grammarLoc);
        if (!g.exists()) {
            throw new PepException("grammar file does not exist");
        }
        if (!g.isFile()) {
            throw new PepException("specified grammar is not a file");
        }
        return g;
    }

    private static final List<String> readTokens(Iterator<String> args) {
        ArrayList<String> tokens = new ArrayList<String>();
        Pattern q = Pattern.compile("\"");
        while (args.hasNext()) {
            String t = args.next();
            if (t == null) {
                tokens.add(t);
                continue;
            }
            if (tokens.isEmpty()) {
                if (t.startsWith("\"")) {
                    tokens.add(q.matcher(t).replaceAll(""));
                    continue;
                }
                tokens.add(t);
                continue;
            }
            if (t.endsWith("\"")) {
                tokens.add(q.matcher(t).replaceAll(""));
                break;
            }
            tokens.add(t);
        }
        return tokens;
    }

    static class GrammarParser
    implements ErrorHandler {
        File grammarFile;
        DocumentBuilder documentBuilder;

        GrammarParser(File grammarFile) throws PepException {
            this.grammarFile = grammarFile;
            try {
                this.documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                this.documentBuilder.setErrorHandler(this);
            }
            catch (ParserConfigurationException pce) {
                throw new PepException("problem instantiating parser", pce);
            }
        }

        Grammar parse() throws PepException {
            Grammar g = null;
            try {
                Document d = this.documentBuilder.parse(this.grammarFile);
                SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                StreamSource src = new StreamSource(this.getClass().getClassLoader().getResourceAsStream("META-INF/etc/grammar.xsd"));
                if (src.getInputStream() == null) {
                    Pep.printMessage("Unable to locate grammar.xsd", 0);
                } else {
                    Schema schema = sf.newSchema(src);
                    Validator vlad = schema.newValidator();
                    try {
                        vlad.validate(new DOMSource(d));
                    }
                    catch (SAXException se) {
                        throw new PepException("invalid grammar", se);
                    }
                }
                Element root = d.getDocumentElement();
                g = new Grammar(root.getAttribute("name"));
                Pep.printMessage("Loading grammar " + g.name + " from " + this.grammarFile.getPath(), 3);
                NodeList rules = root.getElementsByTagName("rule");
                for (int i = 0; i < rules.getLength(); ++i) {
                    Element ruleEl = (Element)rules.item(i);
                    Category left = new Category(ruleEl.getAttribute("category"));
                    NodeList rightList = ruleEl.getChildNodes();
                    ArrayList<Category> right = new ArrayList<Category>(rightList.getLength());
                    for (int j = 0; j < rightList.getLength(); ++j) {
                        Node rightNode = rightList.item(j);
                        if (!(rightNode instanceof Element)) continue;
                        Element rightEl = (Element)rightNode;
                        Attr termAttr = rightEl.getAttributeNode("terminal");
                        right.add(new Category(rightEl.getAttribute("name"), termAttr != null && termAttr.getTextContent().equals("true")));
                    }
                    g.addRule(new Rule(left, right.toArray(new Category[right.size()])));
                }
            }
            catch (IllegalArgumentException iae) {
                throw new PepException("problem loading grammar", iae);
            }
            catch (SAXException se) {
                throw new PepException("problem parsing", se);
            }
            catch (IOException io) {
                throw new PepException("problem reading grammar", io);
            }
            Pep.printMessage(g.toString(), 3);
            Pep.printMessage("", 3);
            return g;
        }

        public void error(SAXParseException e) throws SAXException {
        }

        public void fatalError(SAXParseException e) throws SAXException {
        }

        public void warning(SAXParseException e) throws SAXException {
            Pep.printWarning("line " + e.getLineNumber() + ": " + e.getMessage());
        }
    }
}

