/*
 * Decompiled with CFR 0.152.
 */
package edu.osu.ling.pep;

import edu.osu.ling.pep.Category;
import edu.osu.ling.pep.Chart;
import edu.osu.ling.pep.Edge;
import edu.osu.ling.pep.ParseTree;
import edu.osu.ling.pep.Status;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parse {
    List<String> tokens;
    Category seed;
    Chart chart;
    boolean error;
    private Set<ParseTree> parseTrees;

    Parse(Category seed, Chart chart) {
        this(seed, chart, false);
    }

    Parse(Category seed, Chart chart, boolean error) {
        this.seed = seed;
        this.chart = chart;
        this.error = error;
        this.tokens = new ArrayList<String>();
    }

    public List<String> getTokens() {
        return Collections.unmodifiableList(this.tokens);
    }

    public Category getSeed() {
        return this.seed;
    }

    public Chart getChart() {
        return this.chart;
    }

    Set<Edge> getCompletedEdges(Category category, int origin, int index) {
        Set edges = (Set)this.chart.edgeSets.get(index);
        if (edges == null || edges.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Edge> es = new HashSet<Edge>();
        for (Edge e : edges) {
            if (e.origin != origin || !e.isPassive() || !e.dottedRule.left.equals(category)) continue;
            es.add(e);
        }
        return es;
    }

    public Status getStatus() {
        return this.error ? Status.ERROR : (this.getCompletedEdges(Category.START, 0, this.tokens.size()).isEmpty() ? Status.REJECT : Status.ACCEPT);
    }

    public Set<ParseTree> getParseTrees() {
        if (this.parseTrees == null) {
            this.parseTrees = this.error ? Collections.emptySet() : this.getParseTreesFor(Category.START, 0, this.tokens.size());
        }
        return this.parseTrees;
    }

    public ParseTree getParseTreeFor(Edge edge) {
        if (edge == null) {
            throw new NullPointerException("edge is null");
        }
        if (!this.chart.contains(edge)) {
            return null;
        }
        return ParseTree.newParseTree(edge);
    }

    public Set<ParseTree> getParseTreesFor(Category category, int origin, int index) {
        if (category == null) {
            throw new NullPointerException("null category");
        }
        HashSet<ParseTree> trees = new HashSet<ParseTree>();
        for (Edge e : this.getCompletedEdges(category, origin, index)) {
            trees.add(ParseTree.newParseTree(e));
        }
        return trees;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Parse) {
            Parse op = (Parse)obj;
            return this.error == op.error && ((Object)this.tokens).equals(op.tokens) && this.seed.equals(op.seed) && this.chart.equals(op.chart);
        }
        return false;
    }

    public int hashCode() {
        return 31 * ((Object)this.tokens).hashCode() * this.seed.hashCode() * this.chart.hashCode();
    }

    public String toString() {
        Status status = this.getStatus();
        StringBuilder sb = new StringBuilder(status.toString());
        sb.append(": ");
        sb.append(this.seed);
        sb.append(" -> ");
        sb.append(this.tokens);
        if (status.equals((Object)Status.ACCEPT)) {
            sb.append(" (");
            sb.append(this.getParseTrees().size());
            sb.append(')');
        }
        return sb.toString();
    }
}

