/*
 * Decompiled with CFR 0.152.
 */
package edu.osu.ling.pep;

import edu.osu.ling.pep.Category;
import edu.osu.ling.pep.Rule;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Grammar {
    String name;
    Map<Category, Set<Rule>> rules;

    public Grammar(String name) {
        this.name = name;
        this.rules = new HashMap<Category, Set<Rule>>();
    }

    public String getName() {
        return this.name;
    }

    public boolean addRule(Rule rule) {
        Set<Object> r;
        if (rule == null) {
            throw new NullPointerException("null rule");
        }
        if (!this.rules.containsKey(rule.left)) {
            r = new HashSet();
            this.rules.put(rule.left, r);
        } else {
            r = this.rules.get(rule.left);
        }
        return r.add(rule);
    }

    public boolean containsRules(Category left) {
        return this.rules.containsKey(left);
    }

    public Set<Rule> getRules(Category left) {
        return this.rules.get(left);
    }

    public Set<Rule> getAllRules() {
        HashSet<Rule> allRules = new HashSet<Rule>();
        for (Set<Rule> s : this.rules.values()) {
            allRules.addAll(s);
        }
        return allRules;
    }

    Rule getSingletonPreterminal(Category left, String token, boolean ignoreCase) {
        if (this.rules.containsKey(left)) {
            for (Rule r : this.rules.get(left)) {
                if (!r.isSingletonPreterminal() || !r.right[0].name.equals(token) && (!ignoreCase || !r.right[0].name.equalsIgnoreCase(token))) continue;
                return r;
            }
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        sb.append(this.getClass().getSimpleName());
        sb.append(' ');
        sb.append(this.name);
        sb.append(": {");
        Iterator<Set<Rule>> si = this.rules.values().iterator();
        while (si.hasNext()) {
            Iterator<Rule> ri = si.next().iterator();
            while (ri.hasNext()) {
                sb.append(ri.next().toString());
                if (!ri.hasNext()) continue;
                sb.append(", ");
            }
            if (!si.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}]");
        return sb.toString();
    }
}

