/*
 * Decompiled with CFR 0.152.
 */
package edu.osu.ling.pep;

import edu.osu.ling.pep.Category;
import edu.osu.ling.pep.Chart;
import edu.osu.ling.pep.DottedRule;
import edu.osu.ling.pep.Edge;
import edu.osu.ling.pep.EdgeEvent;
import edu.osu.ling.pep.Grammar;
import edu.osu.ling.pep.Parse;
import edu.osu.ling.pep.ParseErrorEvent;
import edu.osu.ling.pep.ParseEvent;
import edu.osu.ling.pep.ParserListener;
import edu.osu.ling.pep.ParserOption;
import edu.osu.ling.pep.ParserOptionEvent;
import edu.osu.ling.pep.PepException;
import edu.osu.ling.pep.Rule;
import edu.osu.ling.pep.Status;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EarleyParser {
    Grammar grammar;
    ParserListener listener;
    Map<ParserOption, Boolean> options;
    private boolean predictPreterm;
    private boolean ignoreCase;

    public EarleyParser(Grammar grammar) {
        this(grammar, null);
    }

    public EarleyParser(Grammar grammar, ParserListener listener) {
        this.setGrammar(grammar);
        this.setListener(listener);
    }

    public Grammar getGrammar() {
        return this.grammar;
    }

    public void setGrammar(Grammar grammar) {
        if (grammar == null) {
            throw new IllegalArgumentException("null grammar");
        }
        this.grammar = grammar;
    }

    public ParserListener getListener() {
        return this.listener;
    }

    public void setListener(ParserListener listener) {
        this.listener = listener;
    }

    public boolean containsOption(ParserOption optionName) {
        return this.options != null && this.options.containsKey((Object)optionName);
    }

    public Boolean getOption(ParserOption optionName) {
        if (this.options == null) {
            return optionName.defaultValue;
        }
        Boolean o = this.options.get((Object)optionName);
        return o == null ? optionName.defaultValue : o;
    }

    public Boolean setOption(ParserOption optionName, Boolean value) {
        Boolean oldValue;
        if (optionName == null) {
            throw new IllegalArgumentException("null option name");
        }
        if (value == null) {
            throw new IllegalArgumentException("null value");
        }
        if (this.options == null) {
            this.options = new EnumMap<ParserOption, Boolean>(ParserOption.class);
        }
        if ((oldValue = this.options.put(optionName, value)) == null) {
            oldValue = optionName.defaultValue;
        }
        if (!value.equals(oldValue)) {
            this.fireOptionSet(optionName, value);
        }
        return oldValue;
    }

    public Status recognize(String tokens, Category seed) throws PepException {
        return this.recognize(Arrays.asList(tokens.split(" ")), seed);
    }

    public Status recognize(String tokens, String separator, Category seed) throws PepException {
        return this.recognize(Arrays.asList(tokens.split(separator)), seed);
    }

    public Status recognize(Iterable<String> tokens, Category seed) throws PepException {
        return this.parse(tokens, seed).getStatus();
    }

    public Parse parse(String tokens, Category seed) throws PepException {
        return this.parse(Arrays.asList(tokens.split(" ")), seed);
    }

    public Parse parse(String tokens, String separator, Category seed) throws PepException {
        return this.parse(Arrays.asList(tokens.split(separator)), seed);
    }

    public Parse parse(Iterable<String> tokens, Category seed) throws PepException {
        Chart chart = new Chart();
        Integer index = new Integer(0);
        Parse parse = new Parse(seed, chart);
        if (seed == null) {
            this.fireParseError(parse, index, "invalid seed category: " + seed);
        } else if (tokens == null || !tokens.iterator().hasNext()) {
            this.fireParseError(parse, index, "null or empty tokens");
        } else {
            this.predictPreterm = this.getOption(ParserOption.PREDICT_FOR_PRETERMINALS);
            this.ignoreCase = this.getOption(ParserOption.IGNORE_TERMINAL_CASE);
            if (!this.predictPreterm) {
                for (Rule r : this.grammar.getAllRules()) {
                    if (!r.isPreterminal() || r.right.length <= 1) continue;
                    this.predictPreterm = true;
                    this.fireParseMessage(parse, "setting " + ParserOption.PREDICT_FOR_PRETERMINALS.name() + " to true;" + " grammar contains incompatible rule: " + r);
                    break;
                }
            }
            Iterator<String> tokenIterator = tokens.iterator();
            Edge seedEdge = new Edge(DottedRule.startRule(seed), index);
            chart.addEdge(index, seedEdge);
            this.fireParserSeeded(index, seedEdge);
            while (tokenIterator.hasNext()) {
                try {
                    this.predict(chart, index);
                    String token = tokenIterator.next();
                    parse.tokens.add(token);
                    Integer n = index;
                    Integer n2 = index = Integer.valueOf(index + 1);
                    this.scan(chart, n, token);
                    this.complete(chart, index);
                    this.predict(chart, index);
                }
                catch (PepException pe) {
                    this.fireParseError(parse, index, pe);
                }
            }
        }
        this.fireParseComplete(parse);
        return parse;
    }

    void predict(Chart chart, Integer index) {
        if (chart.containsEdges(index)) {
            Set<Edge> edges = chart.getEdges(index);
            for (Edge edge : edges.toArray(new Edge[edges.size()])) {
                this.predictForEdge(chart, edge, index);
            }
        }
    }

    void predictForEdge(Chart chart, Edge edge, Integer index) {
        Category active = edge.dottedRule.activeCategory;
        if (active != null && this.grammar.containsRules(active)) {
            for (Rule rule : this.grammar.getRules(active)) {
                Edge newEdge;
                if (!this.predictPreterm && rule.isPreterminal() || !chart.addEdge(index, newEdge = Edge.predictFor(rule, index))) continue;
                this.fireEdgePredicted(index, newEdge);
                this.predictForEdge(chart, newEdge, index);
            }
        }
    }

    void scan(Chart chart, Integer index, String token) throws PepException {
        if (token == null) {
            throw new PepException("null token at index " + index);
        }
        if (chart.containsEdges(index)) {
            Set<Edge> edges = chart.getEdges(index);
            if (!this.predictPreterm) {
                for (Edge edge : edges.toArray(new Edge[edges.size()])) {
                    Edge pt;
                    Rule r;
                    if (edge.isPassive() || (r = this.grammar.getSingletonPreterminal(edge.dottedRule.activeCategory, token, this.ignoreCase)) == null || !chart.addEdge(index, pt = Edge.predictFor(r, index))) continue;
                    this.fireEdgePredicted(index, pt);
                }
            }
            for (Edge edge : edges.toArray(new Edge[edges.size()])) {
                if (edge.isPassive()) continue;
                DottedRule dr = edge.dottedRule;
                if (!dr.activeCategory.terminal || !dr.activeCategory.name.equals(token) && (!this.ignoreCase || !dr.activeCategory.name.equalsIgnoreCase(token))) continue;
                Edge newEdge = Edge.scan(edge, token);
                Integer successor = new Integer(index + 1);
                if (!chart.addEdge(successor, newEdge)) continue;
                this.fireEdgeScanned(successor, newEdge);
            }
        }
    }

    void complete(Chart chart, Integer index) {
        if (chart.containsEdges(index)) {
            Set<Edge> edges = chart.getEdges(index);
            for (Edge edge : edges.toArray(new Edge[edges.size()])) {
                this.completeForEdge(chart, edge, index);
            }
        }
    }

    void completeForEdge(Chart chart, Edge edge, Integer index) {
        Integer eo = new Integer(edge.origin);
        if (edge.isPassive() && chart.containsEdges(eo)) {
            for (Edge originEdge : chart.getEdges(eo)) {
                Edge newEdge;
                if (originEdge.isPassive() || !originEdge.dottedRule.activeCategory.equals(edge.dottedRule.left) || !chart.addEdge(index, newEdge = Edge.complete(originEdge, edge))) continue;
                this.fireEdgeCompleted(index, newEdge);
                this.completeForEdge(chart, newEdge, index);
            }
        }
    }

    public String toString() {
        return "[" + this.getClass().getSimpleName() + ": grammar " + this.grammar.name + "]";
    }

    private void fireOptionSet(ParserOption option, Boolean value) {
        if (this.listener != null) {
            this.listener.optionSet(new ParserOptionEvent(this, option, value));
        }
    }

    private void fireParserSeeded(Integer index, Edge edge) {
        if (this.listener != null) {
            this.listener.parserSeeded(new EdgeEvent(this, index, edge));
        }
    }

    private void fireEdgePredicted(Integer index, Edge edge) {
        if (this.listener != null) {
            this.listener.edgePredicted(new EdgeEvent(this, index, edge));
        }
    }

    private void fireEdgeScanned(Integer index, Edge edge) {
        if (this.listener != null) {
            this.listener.edgeScanned(new EdgeEvent(this, index, edge));
        }
    }

    private void fireEdgeCompleted(Integer index, Edge edge) {
        if (this.listener != null) {
            this.listener.edgeCompleted(new EdgeEvent(this, index, edge));
        }
    }

    private void fireParseComplete(Parse parse) {
        if (this.listener != null) {
            this.listener.parseComplete(new ParseEvent(this, parse));
        }
    }

    private void fireParseMessage(Parse parse, String message) {
        if (this.listener != null) {
            this.listener.parseMessage(new ParseEvent(this, parse), message);
        }
    }

    private void fireParseError(Parse parse, Integer index, String message) throws PepException {
        this.fireParseError(parse, index, new PepException(message));
    }

    private void fireParseError(Parse parse, Integer index, PepException cause) throws PepException {
        parse.error = true;
        if (this.listener == null) {
            throw cause;
        }
        this.listener.parseError(new ParseErrorEvent(this, index, parse, cause));
    }
}

